/*
 * Decompiled with CFR 0.152.
 */
package music;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import music.Main;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class commonUtils {
    private static Random rand = new Random();
    private static boolean caret = false;

    public static void sleep(int millis) {
        block2: {
            try {
                Thread.sleep(millis);
            }
            catch (Exception e) {
                if (!Main.debugErrors) break block2;
                System.out.println(e);
            }
        }
    }

    public static int[] range(int startingNumber, int endingNumber) {
        return commonUtils.range(startingNumber, endingNumber, 1);
    }

    public static int[] range(int startingNumber, int endingNumber, int increment) {
        int[] range = new int[endingNumber - startingNumber];
        for (int counter = 0; counter < range.length; ++counter) {
            range[counter] = startingNumber + increment * counter;
        }
        return range;
    }

    public static Object[] rangeObj(int startingNumber, int endingNumber) {
        return commonUtils.rangeObj(startingNumber, endingNumber, 1);
    }

    public static Object[] rangeObj(int startingNumber, int endingNumber, int increment) {
        Object[] range = new Object[endingNumber - startingNumber];
        for (int counter = 0; counter < range.length; ++counter) {
            range[counter] = startingNumber + increment * counter;
        }
        return range;
    }

    public static int max(int firstInt, int secondInt) {
        if (secondInt > firstInt) {
            return secondInt;
        }
        return firstInt;
    }

    public static double max(double firstDouble, double secondDouble) {
        if (secondDouble > firstDouble) {
            return secondDouble;
        }
        return firstDouble;
    }

    public static byte max(byte[] byteArray) {
        byte min = byteArray[0];
        for (int x = byteArray.length - 1; x >= 0; --x) {
            if (byteArray[x] <= min) continue;
            min = byteArray[x];
        }
        return min;
    }

    public static int max(int[] intArray) {
        int min = intArray[0];
        for (int x = intArray.length - 1; x >= 0; --x) {
            if (intArray[x] <= min) continue;
            min = intArray[x];
        }
        return min;
    }

    public static double min(double[] doubleArray) {
        double min = doubleArray[0];
        for (int x = doubleArray.length - 1; x >= 0; --x) {
            if (!(doubleArray[x] < min)) continue;
            min = doubleArray[x];
        }
        return min;
    }

    public static byte min(byte[] byteArray) {
        byte min = byteArray[0];
        for (int x = byteArray.length - 1; x >= 0; --x) {
            if (byteArray[x] >= min) continue;
            min = byteArray[x];
        }
        return min;
    }

    public static byte min(byte[] byteArray, byte threshold) {
        byte min = byteArray[0];
        boolean thresh = true;
        for (int x = byteArray.length - 1; x >= 0; --x) {
            if (byteArray[x] > min || byteArray[x] < threshold) continue;
            thresh = false;
            min = byteArray[x];
        }
        if (thresh) {
            return threshold;
        }
        return min;
    }

    public static byte min(byte b, byte c) {
        if (b > c) {
            return c;
        }
        return b;
    }

    public static long sum(int[] intArray) {
        long total = 0L;
        for (int xx = intArray.length - 1; xx >= 0; --xx) {
            total += (long)intArray[xx];
        }
        return total;
    }

    public static long sum(long[] intArray) {
        long total = 0L;
        for (int xx = intArray.length - 1; xx >= 0; --xx) {
            total += intArray[xx];
        }
        return total;
    }

    public static double sum(double[] doubleArray) {
        double total = 0.0;
        for (int xx = doubleArray.length - 1; xx >= 0; --xx) {
            total += doubleArray[xx];
        }
        return total;
    }

    public static int sum(byte[] byteArray) {
        int total = 0;
        for (int xx = byteArray.length - 1; xx >= 0; --xx) {
            total += byteArray[xx];
        }
        return total;
    }

    public static double avg(int[] intArray) {
        return commonUtils.sum(intArray) / (long)intArray.length;
    }

    public static double avg(long[] intArray) {
        return commonUtils.sum(intArray) / (long)intArray.length;
    }

    public static double avg(double[] doubleArray) {
        return commonUtils.sum(doubleArray) / (double)doubleArray.length;
    }

    public static double avg(byte[] byteArray) {
        return commonUtils.sum(byteArray) / byteArray.length;
    }

    public static double standardDev(double[] doubleArray, double average) {
        double stdev = 0.0;
        for (int c = doubleArray.length - 1; c >= 0; --c) {
            stdev += Math.pow(average - doubleArray[c], 2.0);
        }
        return Math.sqrt(stdev / (double)doubleArray.length);
    }

    public static double standardDev(long[] doubleArray, double average) {
        double stdev = 0.0;
        for (int c = doubleArray.length - 1; c >= 0; --c) {
            stdev += Math.pow(average - (double)doubleArray[c], 2.0);
        }
        return Math.sqrt(stdev / (double)doubleArray.length);
    }

    public static double standardDev(int[] integerArray, double average) {
        double stdev = 0.0;
        for (int c = integerArray.length - 1; c >= 0; --c) {
            stdev += Math.pow(average - (double)integerArray[c], 2.0);
        }
        return Math.sqrt(stdev / (double)integerArray.length);
    }

    public static byte[] standardize(byte[] byteArray) {
        byte average = (byte)commonUtils.avg(byteArray);
        int x = byteArray.length - 1;
        while (x >= 0) {
            int n = x--;
            byteArray[n] = (byte)(byteArray[n] - average);
        }
        return byteArray;
    }

    public static double[] standardize(double[] byteArray) {
        double average = commonUtils.avg(byteArray);
        int x = byteArray.length - 1;
        while (x >= 0) {
            int n = x--;
            byteArray[n] = byteArray[n] - average;
        }
        return byteArray;
    }

    public static int indexOf(String findThis, String[] inThis) {
        if (findThis.length() == 0) {
            return -1;
        }
        for (int xx = inThis.length - 1; xx >= 0; --xx) {
            if (!findThis.equals(inThis[xx])) continue;
            return xx;
        }
        return -1;
    }

    public static int indexOf(double findThis, double[] inThis) {
        for (int index = inThis.length - 1; index >= 0; --index) {
            if (findThis != inThis[index]) continue;
            return index;
        }
        return -1;
    }

    public static String choice(String[] options) {
        return options[rand.nextInt(options.length)];
    }

    public static char choice(char[] options) {
        return options[rand.nextInt(options.length)];
    }

    public static char choice(String options) {
        return options.charAt(rand.nextInt(options.length()));
    }

    public static float choice(float[] options) {
        return options[rand.nextInt(options.length)];
    }

    public static double choice(double[] options) {
        return options[rand.nextInt(options.length)];
    }

    public static byte choice(byte[] options) {
        return options[rand.nextInt(options.length)];
    }

    public static short choice(short[] options) {
        return options[rand.nextInt(options.length)];
    }

    public static int choice(int[] options) {
        return options[rand.nextInt(options.length)];
    }

    public static long choice(long[] options) {
        return options[rand.nextInt(options.length)];
    }

    public static String dialogFormat(String dialog, int width) {
        String[] words = dialog.split(" ");
        StringBuffer formatted = new StringBuffer();
        int position = 0;
        for (int ind = 0; ind < words.length; ++ind) {
            int len = commonUtils.wordLength(words[ind]);
            if (len + position <= width) {
                position += len;
                formatted.append(" ").append(words[ind]);
                continue;
            }
            if (words[ind].equals(" ")) continue;
            position = len;
            formatted.append("<br>").append(words[ind]);
        }
        return formatted.toString().trim();
    }

    public static int wordLength(String word) {
        int len = 0;
        float boldMult = 1.0f;
        for (int ind = 0; ind < word.length(); ++ind) {
            if (!caret) {
                if (word.charAt(ind) != '>' && word.charAt(ind) != '<') {
                    len = (int)((float)len + boldMult);
                }
            } else if (word.toLowerCase().charAt(ind) == 'b') {
                boldMult = word.toLowerCase().charAt(ind) == '/' ? 1.0f : 1.5f;
            }
            if (word.charAt(ind) == '>') {
                caret = false;
                continue;
            }
            if (word.charAt(ind) != '<') continue;
            caret = true;
        }
        return len;
    }

    public static int gcf(int intOne, int intTwo) {
        int k = 0;
        if (intOne == 0) {
            return intTwo;
        }
        if (intTwo == 0) {
            return intOne;
        }
        while ((intOne & 1) == 0 && (intTwo & 1) == 0) {
            intOne >>= 1;
            intTwo >>= 1;
            ++k;
        }
        do {
            if ((intOne & 1) == 0) {
                intOne >>= 1;
                continue;
            }
            if ((intTwo & 1) == 0) {
                intTwo >>= 1;
                continue;
            }
            if (intOne >= intTwo) {
                intOne = intOne - intTwo >> 1;
                continue;
            }
            intTwo = intTwo - intOne >> 1;
        } while (intOne > 0);
        return intTwo << k;
    }

    public static int greatestCommonSubsequence(String a, String b) {
        int max = 0;
        for (int ii = 1; ii <= a.length(); ++ii) {
            for (int jj = 0; jj <= a.length() - ii; ++jj) {
                for (int kk = 0; kk <= b.length() - ii; ++kk) {
                    if (!a.substring(jj, jj + ii).equals(b.substring(kk, kk + ii))) continue;
                    max = ii;
                }
            }
        }
        return max;
    }

    public static String doubleToStringFraction(double Double2) {
        String answer = "";
        double[] numerators = new double[]{0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] denominators = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        int maxNumerator = commonUtils.getMaxNumerator(Double2);
        double d2 = Double2;
        double prevCalcD = -1.0;
        for (int i = 2; i < 1000; ++i) {
            double L2 = Math.floor(d2);
            numerators[i] = L2 * numerators[i - 1] + numerators[i - 2];
            if (Math.abs(numerators[i]) > (double)maxNumerator) {
                return answer;
            }
            denominators[i] = L2 * denominators[i - 1] + denominators[i - 2];
            double calcD = numerators[i] / denominators[i];
            if (calcD == prevCalcD) {
                return answer;
            }
            answer = (int)numerators[i] % (int)denominators[i] == 0 ? Integer.toString((int)numerators[i] / (int)denominators[i]) : (int)numerators[i] + "/" + (int)denominators[i];
            if (Math.abs(calcD - Double2) < 1.0E-7) {
                return answer;
            }
            prevCalcD = calcD;
            d2 = 1.0 / (d2 - L2);
        }
        return answer;
    }

    private static int getMaxNumerator(double f) {
        int i;
        int ixe = Double.toString(f).indexOf("E");
        if (ixe == -1) {
            ixe = Double.toString(f).indexOf("e");
        }
        String f2 = ixe == -1 ? Double.toString(f) : Double.toString(f).substring(0, ixe);
        String digits = null;
        int ix = f2.toString().indexOf(".");
        if (ix == -1) {
            digits = f2;
        } else if (ix == 0) {
            digits = f2.substring(1, f2.length());
        } else if (ix < f2.length()) {
            digits = f2.substring(0, ix) + f2.substring(ix + 1, f2.length());
        }
        String L = digits;
        int numDigits = L.toString().length();
        double L2 = f;
        int numIntDigits = Double.toString(L2).length();
        if (L2 == 0.0) {
            numIntDigits = 0;
        }
        int numDigitsPastDecimal = numDigits - numIntDigits;
        int LX = Integer.parseInt(L.substring(0, Math.min(9, L.length())));
        for (i = numDigitsPastDecimal; i > 0 && LX % 2 == 0; --i) {
            LX /= 2;
        }
        for (i = numDigitsPastDecimal; i > 0 && LX % 5 == 0; --i) {
            LX /= 5;
        }
        return LX;
    }

    public static int[] integerVectorToArray(Vector<Integer> vector) {
        int[] i = new int[vector.size()];
        for (int c = 0; c < i.length; ++c) {
            i[c] = vector.get(c);
        }
        return i;
    }

    public static byte[][] byteVectorToArray(Vector<byte[]> vector) {
        byte[][] i = new byte[vector.size()][vector.get(0).length];
        for (int c = 0; c < i.length; ++c) {
            i[c] = vector.get(c);
        }
        return i;
    }

    public static int[] integerArrayListToArray(ArrayList<Integer> arrayList) {
        int[] i = new int[arrayList.size()];
        for (int c = 0; c < i.length; ++c) {
            i[c] = arrayList.get(c);
        }
        return i;
    }

    public static byte[][] byteArrayListToArray(ArrayList<byte[]> arrayList) {
        byte[][] i = new byte[arrayList.size()][arrayList.get(0).length];
        for (int c = 0; c < i.length; ++c) {
            i[c] = arrayList.get(c);
        }
        return i;
    }

    public static byte[] toByteArray(double[] doubleArray) {
        byte[] byteArray = new byte[doubleArray.length];
        for (int x = doubleArray.length - 1; x >= 0; --x) {
            byteArray[x] = (byte)doubleArray[x];
        }
        return byteArray;
    }

    public static void printArray(int[] intArray, int numDigits) {
        for (int y = 0; y < intArray.length; ++y) {
            String disp = Integer.toString(intArray[y]);
            if (disp.length() > numDigits - 1) {
                disp.subSequence(0, numDigits - 1);
            }
            System.out.print(disp);
            for (int x = disp.length(); x <= numDigits; ++x) {
                System.out.print(" ");
            }
        }
        System.out.println("");
    }

    public static void printArray(int[] intArray) {
        commonUtils.printArray(intArray, (int)Math.log10(commonUtils.max(intArray)) + 1);
    }

    public static void printArray(byte[] byteArray, int numDigits) {
        for (int y = 0; y < byteArray.length; ++y) {
            String disp = Integer.toString(byteArray[y]);
            if (disp.length() > numDigits - 1) {
                disp.subSequence(0, numDigits - 1);
            }
            System.out.print(disp);
            for (int x = disp.length(); x <= numDigits; ++x) {
                System.out.print(" ");
            }
        }
        System.out.println("");
    }

    public static void printArray(byte[] byteArray) {
        commonUtils.printArray(byteArray, (int)Math.log10(commonUtils.max(byteArray)) + 1);
    }

    public static void printArray(byte[][] byteArray2D, int numDigits) {
        for (int y = 0; y < byteArray2D.length; ++y) {
            commonUtils.printArray(byteArray2D[y], numDigits);
        }
        System.out.println("");
    }

    public static void printArray(byte[][] byteArray2D) {
        for (int y = 0; y < byteArray2D.length; ++y) {
            commonUtils.printArray(byteArray2D[y]);
        }
        System.out.println("");
    }

    public static void printArray(int[][] intArray2D, int numDigits) {
        for (int y = 0; y < intArray2D.length; ++y) {
            commonUtils.printArray(intArray2D[y], numDigits);
        }
        System.out.println("");
    }

    public static void printArray(int[][] intArray2D) {
        for (int y = 0; y < intArray2D.length; ++y) {
            commonUtils.printArray(intArray2D[y]);
        }
        System.out.println("");
    }

    public static void printArray(String[] stringArray) {
        System.out.println("Array: " + stringArray);
        for (int x = 0; x < stringArray.length; ++x) {
            System.out.println(x + ": " + stringArray[x]);
        }
        System.out.println("");
    }

    public static void printArray(double[] doubleArray) {
        commonUtils.printArray(doubleArray, 4);
    }

    public static void printArray(double[] doubleArray, int numDigits) {
        for (int y = 0; y < doubleArray.length; ++y) {
            String disp = Double.toString(doubleArray[y]);
            if (disp.length() > numDigits - 1) {
                disp = disp.substring(0, numDigits);
            }
            System.out.print(disp);
            for (int x = disp.length(); x <= numDigits; ++x) {
                System.out.print(" ");
            }
        }
        System.out.println("");
    }

    public static String rainbowText(String text, String[] colorStringArray) {
        String rainbow = "<strong>";
        int spaces = 0;
        for (int c = 0; c < text.length(); ++c) {
            if (text.charAt(c) == ' ') {
                rainbow = rainbow + " ";
                spaces = (byte)(spaces + 1);
                continue;
            }
            rainbow = rainbow + "<font color='" + colorStringArray[(c - spaces) % colorStringArray.length] + "'>" + text.charAt(c) + "</font>";
        }
        return rainbow + "</strong>";
    }

    public static String rainbowText(String text, Color[] colorArray) {
        return commonUtils.rainbowText(text, commonUtils.colorsToHexString(colorArray));
    }

    public static Color[] divideSpectrum(int numColors) {
        Color[] colors = new Color[numColors];
        float colorStep = (float)(1.0 / (double)numColors);
        float hue = 0.0f;
        for (int x = 0; x < numColors; ++x) {
            colors[x] = new Color(Color.HSBtoRGB(hue, 1.0f, 1.0f));
            hue += colorStep;
        }
        return colors;
    }

    public static String colorToHexString(Color color) {
        String r = Integer.toHexString(color.getRed());
        String g = Integer.toHexString(color.getGreen());
        String b = Integer.toHexString(color.getBlue());
        if (r.length() == 1) {
            r = "0" + r;
        }
        if (g.length() == 1) {
            g = "0" + g;
        }
        if (b.length() == 1) {
            b = "0" + b;
        }
        return "#" + r + g + b;
    }

    public static String[] colorsToHexString(Color[] colorArray) {
        String[] hex = new String[colorArray.length];
        for (int x = colorArray.length - 1; x >= 0; --x) {
            hex[x] = commonUtils.colorToHexString(colorArray[x]);
        }
        return hex;
    }

    public static void openURL(String url) {
        block3: {
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                url = "http://" + url;
            }
            try {
                BrowserLauncher launcher = new BrowserLauncher();
                launcher.setNewWindowPolicy(true);
                launcher.openURLinBrowser(url);
            }
            catch (Exception ex) {
                if (!Main.debugErrors) break block3;
                System.out.println(ex);
            }
        }
    }

    static void printArray(Double[] spectrum) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    static AudioFormat getAudioFormat() {
        AudioFormat format = null;
        for (int channels = 2; channels >= 1; --channels) {
            try {
                format = new AudioFormat(8000.0f, 8, channels, true, false);
                return format;
            }
            catch (Exception e) {
                try {
                    format = new AudioFormat(44100.0f, 8, channels, true, false);
                    return format;
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
        if (Main.debugErrors) {
            System.out.println("No compatible audio formats detected.");
        }
        return format;
    }
}

